# Pulsar

Re-export of Pulsar packages conveniently under a single import namespace for
consumers.

## How It Works

1. Create a src URL using the provided manifest URL utils.
2. Select a Pulsar backend (PulsarCore, PulsarNative, etc) and render the
   provided component with the desired initial playback state.
3. Use the [Player-Controller](../player-controller/README.md) Context API to
   interact with player state and build custom UI.
4. Use one of the provided analytics hooks to receive fully formed player
   tracking events.

Note: Pulsar Backends can be used interchangeably with the Player-Controller API
and analytics hooks.

## Example

```tsx
import { createStreamManifestUrl, PlayerControllerRoot, PulsarNative, usePlayerController, useStreamAnalytics } from 'pulsar';

export const BasePlayer = () => {
  const controller = usePlayerController();

  // To get player tracking events, use one of the provided content type hooks
  useStreamAnalytics({ onTrackingEvent: () => { /*...*/}, ... });

  // Create a manifest URL
  const streamSourceUrl = createStreamManifestUrl({ ... });

  return (
    <PulsarNative autoPlay muted controls src={streamSourceUrl} />
  );
}

export const Player = () => (
  <PlayerControllerRoot>
    <BasePlayer />
  </PlayerControllerRoot>
);
```

## Video Formats, Codecs and Containers

For a brief primer on all of these topics, watch this
[video](https://www.youtube.com/watch?v=XvoW-bwIeyY&ab_channel=Qencode).
