import { graphql } from 'relay-runtime';

// Use GQL fragments to generate schema-enforced types. Re-export the relevant types from the sibling
// `index.ts` file.

// istanbul ignore next: non-production
// eslint-disable-next-line no-unused-expressions
graphql`
  fragment PulsarAnalytics_StreamUserFragment on User {
    id
    login
    stream {
      id
      game {
        name
      }
    }
    roles {
      isPartner
    }
    self {
      subscriptionBenefit {
        id
      }
    }
  }
`;

// istanbul ignore next: non-production
// eslint-disable-next-line no-unused-expressions
graphql`
  fragment PulsarAnalytics_HostUserFragment on User {
    id
    login
  }
`;

// istanbul ignore next: non-production
// eslint-disable-next-line no-unused-expressions
graphql`
  fragment PulsarAnalytics_VodFragment on Video {
    broadcastType
    game {
      name
    }
    id
    owner {
      id
      login
      roles {
        isPartner
      }
      self {
        subscriptionBenefit {
          id
        }
      }
    }
  }
`;

// istanbul ignore next: non-production
// eslint-disable-next-line no-unused-expressions
graphql`
  fragment PulsarAnalytics_ClipFragment on Clip {
    broadcaster {
      id
      login
      roles {
        isPartner
      }
      self {
        subscriptionBenefit {
          id
        }
      }
    }
    game {
      name
    }
    id
    slug
  }
`;

// istanbul ignore next: non-production
// eslint-disable-next-line no-unused-expressions
graphql`
  fragment PulsarAnalytics_CurrentUserFragment on User {
    id
    hasTurbo
  }
`;
