import type { PlayerAnalyticsEvent, PlayerType } from 'pulsar-utils';
import type { ContentMode } from 'tachyon-event-tracker';
import type { CurrentUserAnalyticsFragment } from './gql-types';

export type TrackingData = {
  playerType: PlayerType;
  /**
   * ID for the current browser session.
   */
  sessionId: string;
};

export type CommonAnalyticsParams = {
  currentUser: CurrentUserAnalyticsFragment | null;
  onTrackingEvent: (event: PlayerAnalyticsEvent) => void;
  tracking: TrackingData;
};

export type CommonTrackingProperties = {
  /**
   * ID that uniquely identifies the browser session playback occurs within.
   */
  benchmark_session_id: string;
  /**
   * Broadcaster's login.
   */
  channel: string | null;
  /**
   * Broadcaster's ID.
   */
  channel_id: string | null;
  /**
   * The top-level content playback categorization.
   */
  content_mode: ContentMode;
  /**
   * The name of the initial game that was played within the content, if any.
   */
  game: string | null;
  /**
   * Whether or not the broadcaster is a partner.
   */
  partner: boolean;
  /**
   * The "player type" being used as corresponding to the parameter specified
   * in requesting a video access token.
   */
  player: PlayerType;
  /**
   * Whether or not the viewer subscribes to the broadcaster.
   */
  subscriber: boolean;
  /**
   * Whether or not the viewer has the Turbo entitlement.
   */
  turbo: boolean;
  /**
   * The viewer's user ID.
   */
  user_id: string | null;
};
