# Pulsar-Restrictions

Detects and manages Twitch playback restrictions.

# How to Use

```tsx
import { useChannelRestrictions } from 'pulsar';

export const StreamPlayerBase = ({ channel }) => {
  const { activeRestriction, addRestriction, removeRestriction } =
    useChannelRestrictions(channel);

  if (restriction) {
    switch (restriction) {
      case 'gql-sub-only':
        return (
          <SubOnlyGate onDismiss={() => removeRestriction('gql-sub-only')} />
        );
    }
  }

  return <SomeVideoPlayer />;
};
```

## Context Base Usage

You can also use the same system through the combination of content-specific
context providers
`ChannelPlaybackRestrictionsRoot`,`ClipPlaybackRestrictionsRoot`,
`VodPlaybackRestrictionsRoot` and the `usePlaybackRestrictions` context consumer
hook.
