import type { FC } from 'react';
import { PlaybackRestrictionsRoot } from '../PlaybackRestrictionsRoot';
import type { ChannelRestrictionsFragment } from '../useChannelRestrictions';
import { useChannelRestrictions } from '../useChannelRestrictions';

// istanbul ignore next: trivial
export const ChannelPlaybackRestrictionsRoot: FC<{
  channel: ChannelRestrictionsFragment;
}> = ({ channel, children }) => {
  const ctx = useChannelRestrictions(channel);
  return <PlaybackRestrictionsRoot children={children} ctx={ctx} />;
};

ChannelPlaybackRestrictionsRoot.displayName = 'ChannelPlaybackRestrictionsRoot';
