import type { FC } from 'react';
import { PlaybackRestrictionsRoot } from '../PlaybackRestrictionsRoot';
import type { ClipRestrictionsFragment } from '../useClipRestrictions';
import { useClipRestrictions } from '../useClipRestrictions';

// istanbul ignore next: trivial
export const ClipPlaybackRestrictionsRoot: FC<{
  clip: ClipRestrictionsFragment;
}> = ({ children, clip }) => {
  const ctx = useClipRestrictions(clip);
  return <PlaybackRestrictionsRoot children={children} ctx={ctx} />;
};

// istanbul ignore next: trivial
ClipPlaybackRestrictionsRoot.displayName = 'ClipPlaybackRestrictionsRoot';
