import type { FC } from 'react';
import { createContext, useContext } from 'react';
import type { UseRestrictions } from '../useRestrictions';

export type PlaybackRestrictionsContext = UseRestrictions;

// istanbul ignore next: trivial
export const playbackRestrictionsContext =
  createContext<PlaybackRestrictionsContext>({
    activeRestriction: null,
    addRestriction: () => null,
    handlePlayerError: () => null,
    removeRestriction: () => null,
  });

// istanbul ignore next: trivial
export const usePlaybackRestrictions = (): PlaybackRestrictionsContext => {
  return useContext(playbackRestrictionsContext);
};

// istanbul ignore next: trivial
export const PlaybackRestrictionsRoot: FC<{
  ctx: UseRestrictions;
}> = ({ children, ctx }) => (
  <playbackRestrictionsContext.Provider children={children} value={ctx} />
);

// istanbul ignore next: trivial
PlaybackRestrictionsRoot.displayName = 'PlaybackRestrictionsRoot';
