import type { FC } from 'react';
import { PlaybackRestrictionsRoot } from '../PlaybackRestrictionsRoot';
import type { VodRestrictionsFragment } from '../useVodRestrictions';
import { useVodRestrictions } from '../useVodRestrictions';

// istanbul ignore next: trivial
export const VodPlaybackRestrictionsRoot: FC<{
  video: VodRestrictionsFragment;
}> = ({ children, video }) => {
  const ctx = useVodRestrictions(video);
  return <PlaybackRestrictionsRoot children={children} ctx={ctx} />;
};

// istanbul ignore next: trivial
VodPlaybackRestrictionsRoot.displayName = 'VodPlaybackRestrictionsRoot';
