import { useEffectOnce } from 'tachyon-utils-react';
import type { MatureChannelFragment } from '../useRestrictions';
import { hasMatureRestriction, useRestrictions } from '../useRestrictions';
import type { SubOnlyLiveChannelFragment } from './subOnlyLive';
import { hasSubOnlyLiveRestriction } from './subOnlyLive';

export type ChannelRestrictionsFragment = MatureChannelFragment &
  SubOnlyLiveChannelFragment;

// istanbul ignore next: trivial
/**
 * Derives the initial restrictions for a given channel from GQL data.
 */
export function determineRestrictions(
  channel: ChannelRestrictionsFragment | null,
): Parameters<typeof useRestrictions>[0] {
  if (!channel) {
    return {};
  }

  return {
    'gql-sub-only': hasSubOnlyLiveRestriction(channel),
  };
}

// istanbul ignore next: trivial
/**
 * Manages restriction checking, setting, and determining whether a restriction
 * prevents playback.
 */
export function useChannelRestrictions(
  channel: ChannelRestrictionsFragment | null,
): ReturnType<typeof useRestrictions> {
  const restriction = useRestrictions(determineRestrictions(channel));

  useEffectOnce(() => {
    // hasMatureRestriction reads a cookie on the client so we need to wrap in an effect
    // to avoid a server/client mistmatch upon hydration.
    if (hasMatureRestriction(channel)) {
      restriction.addRestriction('gql-mature');
    }
  });

  return restriction;
}
