export type SubOnlyLiveChannelFragment = {
  stream: {
    restrictionType: string | null;
    self: {
      canWatch: boolean;
    } | null;
  } | null;
};

export function hasSubOnlyLiveRestriction({
  stream,
}: SubOnlyLiveChannelFragment): boolean {
  // Assume the user can watch when we're in a degraded state. This restriction is to provide
  // more context for the user, the player will prevent watching sub only live content without this
  // check.
  const canWatch = stream?.self?.canWatch ?? true;
  return !canWatch && stream?.restrictionType === 'SUB_ONLY_LIVE';
}
