import type { SubOnlyLiveChannelFragment } from '.';
import { hasSubOnlyLiveRestriction } from '.';

describe(hasSubOnlyLiveRestriction, () => {
  const mockChannel = (
    overrides?: Partial<SubOnlyLiveChannelFragment['stream']>,
  ): SubOnlyLiveChannelFragment => ({
    stream: {
      restrictionType: '12',
      self: {
        canWatch: false,
      },
      ...overrides,
    },
  });

  describe('false when', () => {
    it('stream is null', () => {
      expect(hasSubOnlyLiveRestriction({ stream: null })).toEqual(false);
    });

    it('self is null', () => {
      const channel = mockChannel({
        restrictionType: 'SUB_ONLY_LIVE',
        self: null,
      });
      expect(hasSubOnlyLiveRestriction(channel)).toEqual(false);
    });

    it('channel can watch', () => {
      const channel = mockChannel({
        restrictionType: 'SUB_ONLY_LIVE',
        self: { canWatch: true },
      });
      expect(hasSubOnlyLiveRestriction(channel)).toEqual(false);
    });

    it('restrictionType is not sub only live', () => {
      const channel = mockChannel({
        restrictionType: 'ALL_ACCESS_PASS',
        self: { canWatch: false },
      });
      expect(hasSubOnlyLiveRestriction(channel)).toEqual(false);
    });
  });

  describe('true when', () => {
    it('restrictionType is sub only live and channel cannot watch', () => {
      const channel = mockChannel({
        restrictionType: 'SUB_ONLY_LIVE',
        self: { canWatch: false },
      });

      expect(hasSubOnlyLiveRestriction(channel)).toEqual(true);
    });
  });
});
