import { useEffectOnce } from 'tachyon-utils-react';
import type { MatureChannelFragment } from '../useRestrictions';
import { hasMatureRestriction, useRestrictions } from '../useRestrictions';

export type ClipRestrictionsFragment = {
  broadcaster: MatureChannelFragment | null;
};

/**
 * Manages restriction checking, setting, and determining whether a restriction
 * prevents playback.
 */
export function useClipRestrictions(
  clip: ClipRestrictionsFragment | null,
): ReturnType<typeof useRestrictions> {
  const restriction = useRestrictions();

  // hasMatureRestriction reads a cookie on the client so we need to wrap in an effect
  // to avoid a server/client mistmatch upon hydration.
  useEffectOnce(() => {
    if (hasMatureRestriction(clip?.broadcaster)) {
      restriction.addRestriction('gql-mature');
    }
  });

  return restriction;
}
