import { lacksMatureCookie } from 'pulsar-utils';

export type MatureChannelFragment = {
  broadcastSettings: {
    isMature: boolean;
  } | null;
};

export function hasMatureRestriction(
  channel: MatureChannelFragment | null | undefined,
): boolean {
  // Assume content is mature when we're in a degraded state
  // and not receiving broadcastSettings. We don't want to show un-gated
  // mature content, so when we're unsure we accept the risk of unnecessarily
  // showing the check.
  const isMature = channel?.broadcastSettings?.isMature ?? true;
  return isMature && lacksMatureCookie() === true;
}
