import { lacksMatureCookie } from 'pulsar-utils';
import { hasMatureRestriction } from '.';

jest.mock('pulsar-utils', () => ({
  lacksMatureCookie: jest.fn(() => undefined),
}));

const mockLacksMatureCookie = lacksMatureCookie as jest.Mock;

describe(hasMatureRestriction, () => {
  beforeEach(() => {
    jest.resetAllMocks();
  });

  describe('false when', () => {
    it('broadcast is not mature', () => {
      const user = { broadcastSettings: { isMature: false } };
      expect(hasMatureRestriction(user)).toEqual(false);
    });

    it('broadcast is mature but the mature cookie is set', () => {
      mockLacksMatureCookie.mockReturnValue(false);
      const user = { broadcastSettings: { isMature: true } };
      expect(hasMatureRestriction(user)).toEqual(false);
    });
  });

  describe('true when', () => {
    it('broadcastSettings is null', () => {
      mockLacksMatureCookie.mockReturnValue(true);
      const user = { broadcastSettings: null };
      expect(hasMatureRestriction(user)).toEqual(true);
    });

    it('broadcast is mature and no mature cookie is set', () => {
      mockLacksMatureCookie.mockReturnValue(true);
      const user = { broadcastSettings: { isMature: true } };
      expect(hasMatureRestriction(user)).toEqual(true);
    });
  });
});
