import type { PlayerError } from 'pulsar-player-controller';
import { PLAYER_ERROR_RESTRICTION_MAPPINGS } from '../test-mocks';
import { restrictionFromPlayerError } from '.';

describe(restrictionFromPlayerError, () => {
  it.each(Object.entries(PLAYER_ERROR_RESTRICTION_MAPPINGS))(
    'returns %S for each error',
    (restriction, error) => {
      expect(restrictionFromPlayerError(error as PlayerError)).toEqual(
        restriction,
      );
    },
  );
});
