import type { PlayerError } from 'pulsar-player-controller';
import { AuthorizationError, ErrorType } from 'pulsar-player-controller';
import type { PlayerRestriction } from './restrictionFromPlayerError';

export const PLAYER_ERROR_RESTRICTION_MAPPINGS: Readonly<{
  [key in PlayerRestriction]: PlayerError;
}> = {
  'playback-ended': {
    code: 404,
    source: 'MasterPlaylist',
    type: ErrorType.NOT_AVAILABLE,
  } as PlayerError,
  'playback-error': { type: ErrorType.TIMEOUT } as PlayerError,
  'player-auth-drm': {
    code: AuthorizationError.UNSUPPORTED_DEVICE,
    type: ErrorType.AUTHORIZATION,
  } as PlayerError,
  'player-auth-geo': {
    code: AuthorizationError.GEOBLOCKED,
    type: ErrorType.AUTHORIZATION,
  } as PlayerError,
  'player-auth-unknown': {
    code: AuthorizationError.ANONYMIZER_BLOCKED,
    type: ErrorType.AUTHORIZATION,
  } as PlayerError,
  'player-auth-vod-sub-only': {
    code: AuthorizationError.VOD_RESTRICTED,
    type: ErrorType.AUTHORIZATION,
  } as PlayerError,
};
