import { hasMutedVideoSegments } from '.';

describe(hasMutedVideoSegments, () => {
  it('returns true if there are muted segments', () => {
    expect(
      hasMutedVideoSegments({
        muteInfo: {
          mutedSegmentConnection: {
            nodes: [
              {
                duration: 123,
              },
            ],
          },
        },
      }),
    ).toEqual(true);
  });

  it('returns false if there are no muted segments', () => {
    expect(
      hasMutedVideoSegments({
        muteInfo: {
          mutedSegmentConnection: {
            nodes: [],
          },
        },
      }),
    ).toEqual(false);
  });
});
