export type SubOnlyVideoFragment = {
  resourceRestriction: {
    type: string;
  } | null;
};

// https://localhost.tv.twitch.tv/videos/928302177
export function hasSubOnlyVideoRestriction({
  resourceRestriction,
}: SubOnlyVideoFragment): boolean {
  // The current user's ability to watch Sub-Only Archives can't be safely detected through GQL.
  // The Video will indicate if it is a Sub-Only archive via "subscriptionProducts" and the
  // currentUser has a sub product for the channel, but users like admin
  // or staff will bypass that logic. The only safe way is to rely on the
  // player to return the corresponding Authorization Error since Sub-Only Archives
  // result in a "restricted_bitrates" value in a Playback Access Token.
  return resourceRestriction?.type === 'SUB_ONLY_LIVE';
}
