import type { VodRestrictionsFragment } from '.';
import { determineVodRestrictions } from '.';

const buildMockVod = (
  overrides?: Partial<VodRestrictionsFragment>,
): VodRestrictionsFragment => {
  return {
    muteInfo: {
      mutedSegmentConnection: {
        nodes: [],
      },
    },
    owner: {
      broadcastSettings: {
        isMature: false,
      },
    },
    resourceRestriction: null,
    ...overrides,
  };
};

describe(determineVodRestrictions, () => {
  it('returns no restrictions if the given vod has no owner', () => {
    const restrictions = determineVodRestrictions(
      buildMockVod({ owner: null }),
    );
    expect(restrictions).not.toBeUndefined();
    for (const [_, v] of Object.entries(restrictions ?? [])) {
      expect(v).toBeFalsy();
    }
  });

  it('returns a sub-only restriction if broadcaster has sub only live archive', () => {
    const restrictions = determineVodRestrictions(
      buildMockVod({
        resourceRestriction: { type: 'SUB_ONLY_LIVE' },
      }),
    );

    expect(restrictions?.['gql-sub-only']).toEqual(true);
  });

  it('returns a gql-vod-muted-segments restriction if vod has muted segments', () => {
    const restrictions = determineVodRestrictions(
      buildMockVod({
        muteInfo: {
          mutedSegmentConnection: {
            nodes: [{ duration: 20 }],
          },
        },
      }),
    );

    expect(restrictions?.['gql-vod-muted-segments']).toEqual(true);
  });
});
