import { browserSupportsMSE } from '../browserSupportsMSE';

export const TWITCH_HLS_MIME_AND_CODECS =
  'video/mp2t; codecs="avc1.4D402A,mp4a.40.2"';

/**
 * Client-side only. Tests whether the browser supports HLS for the given codecs
 * Twitch will use.
 */
// istanbul ignore next: trivial
export function browserSupportsHLS(video?: HTMLVideoElement): boolean {
  if (
    browserSupportsMSE() &&
    MediaSource.isTypeSupported(TWITCH_HLS_MIME_AND_CODECS)
  ) {
    return true;
  }

  // The nintendo switch can support HLS, but not MSE. So rather than returning false immedietely,
  // lets check if the native video element can play the content type.
  return video?.canPlayType('application/x-mpegURL') !== '';
}
