import { isBrowser } from 'tachyon-utils-stdlib';
import { getAndExtendCookieValue, setCookieValue } from 'tachyon-utils-twitch';

const OLD_CAPTIONS_COOKIE_NAME = 'captionsEnabled';
const CAPTIONS_COOKIE_NAME = 'tachyon-captions-enabled';

// istanbul ignore next: trivial
export function hasCaptionsEnabledCookie(): boolean {
  return (
    isBrowser() &&
    getAndExtendCookieValue({
      migrationNames: [OLD_CAPTIONS_COOKIE_NAME],
      name: CAPTIONS_COOKIE_NAME,
    }) === 'true'
  );
}

// istanbul ignore next: trivial
export function setCaptionsCookie(enabled: boolean): void {
  setCookieValue({
    name: CAPTIONS_COOKIE_NAME,
    value: String(enabled),
  });
}

const OLD_MATURE_COOKIE_NAME = 'mature';
const MATURE_COOKIE_NAME = 'tachyon-mature';

/**
 * Returns boolean on the client definitively representing the state of the cookie
 * Returns undefined on the server where cookie state is unknown
 * For most use-cases, false and undefined are equivalent
 */
// istanbul ignore next: trivial
export function lacksMatureCookie(): boolean | undefined {
  return isBrowser()
    ? getAndExtendCookieValue({
        migrationNames: [OLD_MATURE_COOKIE_NAME],
        name: MATURE_COOKIE_NAME,
      }) !== 'true'
    : undefined;
}

// istanbul ignore next: trivial
export function setMatureCookie(): void {
  setCookieValue({
    name: MATURE_COOKIE_NAME,
    value: 'true',
  });
}
