import type { Quality } from '../types';

export function formatVideoQualityName(
  quality: Quality<{ name?: string }>,
): string {
  if (quality.name) {
    return quality.name;
  }

  return quality.framerate !== 30
    ? `${quality.height}p${quality.framerate}`
    : `${quality.height}`;
}
