import { formatVideoQualityName } from '.';

describe(formatVideoQualityName, () => {
  it('defaults to the existing name on the quality', () => {
    const quality = {
      bitrate: 1000,
      framerate: 60,
      height: 1080,
      name: '1080p60 (source)',
      width: 1920,
    };

    expect(formatVideoQualityName(quality)).toBe(quality.name);
  });

  it('returns the height given a framerate of 30', () => {
    const quality = {
      bitrate: 1000,
      framerate: 30,
      height: 480,
      width: 720,
    };
    const expectedName = String(quality.height);

    expect(formatVideoQualityName(quality)).toBe(expectedName);
  });

  it('formats name with framerate appended', () => {
    const quality = {
      bitrate: 1000,
      framerate: 60,
      height: 720,
      width: 1080,
    };
    const expectedName = '720p60';

    expect(formatVideoQualityName(quality)).toBe(expectedName);
  });
});
