import { Parser } from 'm3u8-parser';

/**
 * Checks if there are at least one quality (720 for 720p, 480 for 480p, etc) in minimumQualities present in the manifest
 *
 * @example
 *
 * manifestHasMinimumQualities('link-to-main-manifest', [720, 480, 360]);
 */
// istanbul ignore next: trivial
export async function manifestHasMinimumQualities(
  manifestUrl: string,
  minimumQualities: Array<number>,
): Promise<boolean> {
  const manifest = await fetchManifest(manifestUrl);
  const availableResolutions = parseResolutionsFromManifest(manifest);

  const hasAtleastOneQuality = Boolean(
    availableResolutions.filter((height) => minimumQualities.includes(height))
      .length,
  );

  return hasAtleastOneQuality;
}

// istanbul ignore next: trivial
function parseResolutionsFromManifest(manifest: string): Array<number> {
  const parser = new Parser();
  parser.push(manifest);
  parser.end();

  const { playlists } = parser.manifest;

  return (playlists ?? []).map(
    (playlist: any) => playlist.attributes.RESOLUTION.height,
  );
}

// istanbul ignore next: trivial
async function fetchManifest(manifestUrl: string): Promise<string> {
  const response = await fetch(manifestUrl);
  return response.text();
}
