import type { TwitchEventProperties } from 'tachyon-type-library';

/**
 * Describes the underlying technology used for playback.
 * "mediaplayer" is the legacy name used for Player-Core.
 */
export type PulsarBackend = 'hlsjs' | 'mediaplayer' | 'native';

export type PlaybackAccessToken = {
  signature: string;
  value: string;
};

export type Quality<Extensions = {}> = Extensions & {
  /** The bitrate of the media in bits per second. */
  bitrate: number;
  /**
   *  The frame rate of the track, or zero if unknown or not applicable.
   */
  framerate: number;
  /** The video height, or zero if unknown or not applicable. */
  height: number;
  /** The video width, or zero if unknown or not applicable. */
  width: number;
};

// TODO: this should either just be a rename of TwitchEvent or be removed
// entirely and have TwitchEvent used directly elsewhere
// https://jira.xarth.tv/browse/EMP-4429
export type PlayerAnalyticsEvent = {
  name: string;
  properties: TwitchEventProperties;
};

/**
 * Common prop interface used by all Pulsar players. Any fields added here
 * need to be implemented in each Pulsar player.
 */
export type PulsarProps = {
  /**
   * Whether or not to autoplay content on load.
   */
  autoPlay?: boolean | undefined;
  className?: string | undefined;
  /**
   * Whether or not to load show native browser video controls. Defaults to false.
   */
  controls?: boolean | undefined;
  /**
   * Whether or not the content should loop on end, if possible.
   */
  loop?: boolean | undefined;
  /**
   * Whether or not to mute content on load.
   */
  muted?: boolean | undefined;
  /**
   * An optional URL for an image to be shown while the video is downloading. If this
   * attribute isn't specified, nothing is displayed until the first frame is available,
   * then the first frame is shown as the poster frame.
   */
  poster?: string | undefined;
  /**
   * Url used to load the content to play.
   */
  src: string | null;
  /**
   * Number of seconds to start from the beginning of the content for the first
   * play. Only relevant for recorded content (VOD and Clip). Defaults to zero.
   */
  startTime?: number | undefined;
  /**
   * A default volume level to set for playback between 0.0 and 1.0.
   */
  volume?: number | undefined;
};
