import { createMountWrapperFactory } from 'tachyon-test-utils';
import { Button, CheckBox } from 'twitch-core-ui';
import { ConfirmationScreen } from '.';

describe(ConfirmationScreen, () => {
  const setup = createMountWrapperFactory(ConfirmationScreen, () => ({
    onToggleBlockUser: jest.fn(),
  }));

  it('renders confirmation copy and block prompt by default', () => {
    const { wrapper } = setup();
    expect(
      wrapper.find({
        children:
          'Our specialists will be reviewing and taking action on their findings.',
      }),
    ).toExist();

    expect(
      wrapper.find({
        children:
          'If you want, you can also block this user to stop seeing their content around the site.',
      }),
    ).toExist();

    expect(wrapper.find(CheckBox)).toExist();
  });

  it('calls onToggleBlockUser when block checkbox is ticked', () => {
    const mockOnToggleBlockUser = jest.fn();
    const { wrapper } = setup({ onToggleBlockUser: mockOnToggleBlockUser });
    wrapper.find(CheckBox).find('input').simulate('change');
    expect(mockOnToggleBlockUser).toHaveBeenCalledTimes(1);
  });

  it('calls onClickClose when close button is clicked', () => {
    const mockOnClose = jest.fn();
    const { wrapper } = setup({ onClickClose: mockOnClose });
    wrapper.find({ children: 'Close' }).find(Button).simulate('click');
    expect(mockOnClose).toHaveBeenCalledTimes(1);
  });

  it('hides block prompt and checkbox when hideBlockPrompt is true', () => {
    const { wrapper } = setup({ hideBlockPrompt: true });

    expect(
      wrapper.find({
        children:
          'If you want, you can also block this user to stop seeing their content around the site.',
      }),
    ).toHaveLength(0);
    expect(wrapper.find(CheckBox)).toHaveLength(0);
  });
});
