import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { Button, ButtonType, Column, Grid, Layout } from 'twitch-core-ui';
import type {
  ReportContentType,
  ReportableContentFragment,
} from '../../gql-types';
import { getContentString } from '../../utils';

export type ContentSelectProps = {
  contents: ReadonlyArray<ReportableContentFragment>;
  onSelect: (content: ReportContentType) => void;
};

export const ContentSelect: FC<ContentSelectProps> = ({
  contents,
  onSelect,
}) => {
  const { formatMessage } = useIntl();
  return (
    <Layout fullWidth>
      <Grid>
        {contents.map((content) => {
          const contentLabel = getContentString(content.type, formatMessage);
          return (
            <Column cols={{ default: 12, sm: 6 }} key={content.type}>
              <Layout margin={{ bottom: 1 }}>
                <Button
                  fullWidth
                  onClick={() => onSelect(content.type)}
                  variant={ButtonType.Secondary}
                >
                  {contentLabel}
                </Button>
              </Layout>
            </Column>
          );
        })}
      </Grid>
    </Layout>
  );
};

ContentSelect.displayName = 'ContentSelect';
