import { DefaultTwitchIntl } from 'tachyon-intl';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { Button } from 'twitch-core-ui';
import { mockContents } from '../../models';
import { getContentString } from '../../utils';
import { ContentSelect } from '.';

describe(ContentSelect, () => {
  const setup = createMountWrapperFactory(ContentSelect, () => ({
    contents: mockContents,
    onSelect: jest.fn(),
  }));

  it('renders buttons for every content', () => {
    const { wrapper } = setup();
    expect(wrapper.find(Button)).toHaveLength(mockContents.length);
  });

  it('calls onSelect when a content is clicked', () => {
    const onSelectHandler = jest.fn();
    const { wrapper } = setup({ onSelect: onSelectHandler });
    wrapper.find(Button).at(0).simulate('click');
    expect(onSelectHandler).toHaveBeenCalledWith(mockContents[0].type);
  });

  it('displays content label from getContentString', () => {
    const { wrapper } = setup();
    wrapper.find(Button).forEach((button, ind) => {
      const expected = getContentString(
        mockContents[ind].type,
        DefaultTwitchIntl.formatMessage,
      );
      expect(button.text()).toBe(expected);
    });
  });
});
