import { createMountWrapperFactory } from 'tachyon-test-utils';
import type { ReportDeadEndType } from '../../gql-types';
import { DeadEndScreen } from '.';

describe(DeadEndScreen, () => {
  const setup = createMountWrapperFactory(DeadEndScreen, () => ({
    deadEndType: 'REPORTABLE',
  }));

  it('renders different copy depending on deadend type', () => {
    const testCases = [
      {
        body: 'Intellectual Property violations are covered under Twitch’s Developer Agreement',
        deadEndType: 'LINK_DMCA_GUIDELINES',
        linkTexts: [
          'View our DMCA Notification Guidelines',
          'View our Trademark Policy',
          'View our Developer Agreement',
        ],
      },
      {
        body: 'If you are at a Twitch in-person event and need support',
        deadEndType: 'LINK_OFF_PLATFORM_GUIDELINES',
        linkTexts: [
          'View our Events Code of Conduct',
          'View our Off-Service Conduct Policy',
        ],
      },
      {
        body: 'To help improve accuracy in Twitch safety reports',
        deadEndType: 'REPORT_FROM_CLIP',
        linkTexts: [],
      },
      {
        body: 'To help improve accuracy in Twitch safety reports',
        deadEndType: 'REPORT_FROM_VOD',
        linkTexts: [],
      },
    ];

    testCases.forEach((tc) => {
      const deadEndType = tc.deadEndType as ReportDeadEndType;
      const { wrapper } = setup({ deadEndType });

      expect(wrapper.text()).toContain('Thank you for your concern');
      expect(wrapper.text()).toContain(tc.body);
      tc.linkTexts.forEach((lt) => {
        expect(wrapper.text()).toContain(lt);
      });
    });
  });
});
