import type { FC, FormEventHandler } from 'react';
import { useState } from 'react';
import { useIntl } from 'tachyon-intl';
import {
  Color,
  Display,
  FormGroup,
  JustifyContent,
  Layout,
  TextArea,
} from 'twitch-core-ui';

export type DescriptionFormProps = {
  onChange: (description: string) => void;
};

export const MAX_DESCRIPTION_LENGTH = 2000;

export const DescriptionForm: FC<DescriptionFormProps> = ({ onChange }) => {
  const { formatMessage } = useIntl();
  const [descriptionLength, setDescriptionLength] = useState<number>(0);

  const onInputChange: FormEventHandler<HTMLTextAreaElement> = (e) => {
    const inputValue = e.currentTarget.value.trim();
    onChange(inputValue);
    setDescriptionLength(inputValue.length);
  };

  return (
    <Layout fullWidth>
      <FormGroup
        label={formatMessage('Tell us more', 'ReportDescriptionForm')}
        labelOptional={formatMessage(
          'Please include timestamp if applicable',
          'ReportDescriptionForm',
        )}
      >
        <TextArea onChange={onInputChange} />
      </FormGroup>
      <Layout
        color={Color.Alt2}
        display={Display.Flex}
        fullWidth
        justifyContent={JustifyContent.End}
        padding={{ top: 0.5 }}
      >
        {`${descriptionLength}/${MAX_DESCRIPTION_LENGTH}`}
      </Layout>
    </Layout>
  );
};

DescriptionForm.displayName = 'DescriptionForm';
