import type { FormEvent } from 'react';
import { act } from 'react-dom/test-utils';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { TextArea } from 'twitch-core-ui';
import { DescriptionForm, MAX_DESCRIPTION_LENGTH } from '.';

describe(DescriptionForm, () => {
  const setup = createShallowWrapperFactory(DescriptionForm, () => ({
    onChange: jest.fn(),
  }));

  it('shows the current character count', () => {
    const { wrapper } = setup();
    const textAreaValue = 'some text';
    act(() => {
      wrapper
        .find(TextArea)
        .props()
        .onChange?.({
          currentTarget: { value: textAreaValue },
        } as FormEvent<HTMLTextAreaElement>);
    });
    wrapper.update();
    expect(wrapper).toIncludeText(
      `${textAreaValue.length}/${MAX_DESCRIPTION_LENGTH}`,
    );
  });

  it('calls onChange with the trimmed input value', () => {
    const { props, wrapper } = setup();
    const textAreaValue = 'some text          ';
    act(() => {
      wrapper
        .find(TextArea)
        .props()
        .onChange?.({
          currentTarget: { value: textAreaValue },
        } as FormEvent<HTMLTextAreaElement>);
    });
    wrapper.update();
    expect(wrapper).toIncludeText(
      `${textAreaValue.trim().length}/${MAX_DESCRIPTION_LENGTH}`,
    );
    expect(props.onChange).toHaveBeenCalledWith(textAreaValue.trim());
  });
});
