import type { FC } from 'react';
import { Button, ButtonType, Column, Grid, Layout } from 'twitch-core-ui';
import type { DetailedReportReasonFragment } from '../../gql-types';

export type DetailedReasonSelectProps = {
  onSelect: (reasonID: string) => void;
  reasons: ReadonlyArray<DetailedReportReasonFragment>;
};

export const DetailedReasonSelect: FC<DetailedReasonSelectProps> = ({
  onSelect,
  reasons,
}) => {
  return (
    <Layout fullWidth>
      <Grid>
        {reasons.map((reason) => (
          <Column cols={{ default: 12, sm: 6 }} key={reason.id}>
            <Layout margin={{ bottom: 1 }}>
              <Button
                fullWidth
                onClick={() => onSelect(reason.id)}
                variant={ButtonType.Secondary}
              >
                {reason.title}
              </Button>
            </Layout>
          </Column>
        ))}
      </Grid>
    </Layout>
  );
};

DetailedReasonSelect.displayName = 'DetailedReasonSelect';
