import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Button } from 'twitch-core-ui';
import { mockDetailedReasons } from '../../models';
import { DetailedReasonSelect } from '.';

describe(DetailedReasonSelect, () => {
  const setup = createShallowWrapperFactory(DetailedReasonSelect, () => ({
    onSelect: jest.fn(),
    reasons: mockDetailedReasons,
  }));

  it('renders all reason buttons', () => {
    const { props, wrapper } = setup();
    expect(wrapper.find(Button)).toHaveLength(props.reasons.length);
  });

  it('calls onSelect when clicking a reason', () => {
    const { props, wrapper } = setup();
    const firstReason = props.reasons[0];
    wrapper.find(Button).first().simulate('click');
    expect(props.onSelect).toHaveBeenCalledWith(firstReason.id);
  });
});
