import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import {
  Background,
  BorderRadius,
  Color,
  CoreText,
  Layout,
  TextAlign,
  Title,
  TitleSize,
} from 'twitch-core-ui';
import type {
  DetailedReportReasonFragment,
  ReportContentType,
  ReportReasonFragment,
} from '../../gql-types';
import { getContentString } from '../../utils';
import { getReportingContentLabel } from './utils';

export type FormPreviewProps = {
  content?: ReportContentType;
  detailedReason?: DetailedReportReasonFragment;
  disclosureText?: string;
  reason?: ReportReasonFragment;
  username?: string;
};

export const FormPreview: FC<FormPreviewProps> = ({
  content,
  detailedReason,
  disclosureText,
  reason,
  username,
}) => {
  const { formatMessage } = useIntl();
  const contentLabel = getContentString(content, formatMessage);
  return (
    <Layout fullWidth>
      {contentLabel && (
        <Layout margin={{ bottom: 2 }}>
          <Layout margin={{ bottom: 1 }}>
            <Title size={TitleSize.ExtraSmall}>
              {getReportingContentLabel(formatMessage, username, content)}
            </Title>
          </Layout>
          <Layout
            background={Background.Alt}
            border
            borderRadius={BorderRadius.Large}
            padding={2}
            textAlign={TextAlign.Center}
          >
            <Title>{contentLabel}</Title>
          </Layout>
        </Layout>
      )}
      {(reason || detailedReason) && (
        <Layout margin={{ bottom: 2 }}>
          <Layout margin={{ bottom: 1 }}>
            <Title size={TitleSize.ExtraSmall}>
              {formatMessage(
                'Why are you submitting this report?',
                'FormPreviewReasonAndDetailedReason',
              )}
            </Title>
          </Layout>
          <Layout
            background={Background.Alt}
            border
            borderRadius={BorderRadius.Large}
            padding={2}
            textAlign={TextAlign.Center}
          >
            <Title>{reason?.text ?? ''}</Title>
            <Layout color={Color.Alt2}>
              <Title size={TitleSize.Small}>
                {detailedReason?.title ?? ''}
              </Title>
            </Layout>
          </Layout>

          {disclosureText && reason?.isApplicableToCountryRegulations && (
            <Layout margin={{ top: 1 }}>
              <CoreText color={Color.Alt2}>{`* ${disclosureText}`}</CoreText>
            </Layout>
          )}
        </Layout>
      )}
    </Layout>
  );
};

FormPreview.displayName = 'FormPreview';
