import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Title } from 'twitch-core-ui';
import {
  mockDetailedReason,
  mockNetzDGReason,
  mockTOSReason,
} from '../../models';
import { FormPreview } from '.';

describe(FormPreview, () => {
  const setup = createShallowWrapperFactory(FormPreview, () => ({
    username: 'username',
  }));

  it('renders content section when content is provided', () => {
    const { wrapper } = setup({ content: 'CHAT_REPORT' });
    expect(
      wrapper.find(Title).find({
        children: 'You are reporting username for their Chat Messages',
      }),
    ).toExist();
    expect(wrapper.find(Title).find({ children: 'Chat Messages' })).toExist();
  });

  it('renders reason section when reason is provided', () => {
    const { wrapper } = setup({ reason: mockTOSReason });
    expect(
      wrapper
        .find(Title)
        .find({ children: 'Why are you submitting this report?' }),
    ).toExist();
    expect(
      wrapper.find(Title).find({ children: mockTOSReason.text }),
    ).toExist();
  });

  it('renders reason section when reason and detailed reason is provided', () => {
    const { wrapper } = setup({
      detailedReason: mockDetailedReason,
      reason: mockTOSReason,
    });
    expect(
      wrapper
        .find(Title)
        .find({ children: 'Why are you submitting this report?' }),
    ).toExist();
    expect(
      wrapper.find(Title).find({ children: mockTOSReason.text }),
    ).toExist();
    expect(
      wrapper.find(Title).find({ children: mockDetailedReason.title }),
    ).toExist();
  });

  it('renders disclosure text when reason is applicable to country regulations and disclosureText is present', () => {
    const { wrapper } = setup({
      detailedReason: mockDetailedReason,
      disclosureText: 'disclosureText',
      reason: mockNetzDGReason,
    });

    expect(wrapper.find({ children: '* disclosureText' })).toExist();
  });

  it('does not render disclosure text even when reason is applicable to country regulations if disclosureText is not present', () => {
    const { wrapper } = setup({
      detailedReason: mockDetailedReason,
      disclosureText: undefined,
      reason: mockNetzDGReason,
    });

    expect(wrapper.find({ children: '* disclosureText' })).toHaveLength(0);
  });
});
