import type { FormatMessage } from 'tachyon-intl';
import { exhaustedCase } from 'tachyon-utils-ts';
import type { ReportContentType } from '../../gql-types';
import { getContentString } from '../../utils';

// istanbul ignore next: trivial
export const getReportingContentLabel = (
  formatMessage: FormatMessage,
  targetUsername?: string,
  content?: string,
): string => {
  const reportContent = content as ReportContentType;
  const contentString = getContentString(reportContent, formatMessage);
  if (!content || !contentString) {
    return '';
  }
  targetUsername ||= formatMessage('User', 'ReportWizardFormUsername');

  switch (reportContent) {
    case 'CHANNEL_FEED_COMMENT_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Channel Feed Comment",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'CHANNEL_FEED_POST_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Channel Feed Post",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'CHANNEL_POINTS_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Channel Points",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'COLLECTION_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Collection",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'CHAT_REPORT':
      return formatMessage(
        'You are reporting {targetUsername} for their Chat Messages',
        { targetUsername },
        'ReportWizardForm',
      );
    case 'CLIP_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Clip",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'CREATOR_GOAL_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Creator Goal",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'CURSE_PRIVATE_GROUP':
      return formatMessage(
        "You are reporting {targetUsername}'s Curse Private Group",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'CURSE_PUBLIC_GROUP':
      return formatMessage(
        "You are reporting {targetUsername}'s Curse Public Group",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'CURSE_WHISPER':
      return formatMessage(
        "You are reporting {targetUsername}'s Curse Whisper",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'EMOTE_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s emotes",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'EVENT_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Event",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'EXTENSION_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Extension",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'LIVESTREAM_REPORT':
      return formatMessage(
        'You are reporting {targetUsername} for the current live stream',
        { targetUsername },
        'ReportWizardForm',
      );
    case 'LIVE_UP_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Live Up notification",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'OFF_PLATFORM_REPORT':
      return formatMessage(
        'You are reporting {targetUsername} for something that happened off Twitch',
        { targetUsername },
        'ReportWizardForm',
      );
    case 'POLL_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Poll",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'RAID_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Raid",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'REWARD_REDEMPTION_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Reward Redemption",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'ROOM_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Room",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'SINGS_DUET_SEED_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Sings Duet Seed",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'SINGS_GROUP_BIO_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Sings Group Bio",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'SINGS_GROUP_CHAT_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Sings Group Chat",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'SINGS_GROUP_NAME_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Sings Group Name",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'SINGS_VOD_COMMENT_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s Sings Vod Comment",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'UNBAN_REQUEST_REPORT':
      return formatMessage(
        'You are reporting {targetUsername} for their Unban Request Message',
        { targetUsername },
        'ReportWizardForm',
      );
    case 'USER_REPORT':
      return formatMessage(
        'You are reporting {targetUsername}',
        { targetUsername },
        'ReportWizardForm',
      );
    case 'USERNAME_REPORT':
      return formatMessage(
        'You are reporting {targetUsername} for their Username',
        { targetUsername },
        'ReportWizardForm',
      );
    case 'VOD_COMMENT_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s VOD Comment",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'VOD_REPORT':
      return formatMessage(
        "You are reporting {targetUsername}'s VOD or Highlight",
        { targetUsername },
        'ReportWizardForm',
      );
    case 'WHISPER_REPORT':
      return formatMessage(
        'You are reporting {targetUsername} for their Whispers',
        { targetUsername },
        'ReportWizardForm',
      );
    default:
      return exhaustedCase(reportContent, '');
  }
};
