import { graphql } from 'relay-runtime';

// These are used to generate GQL schema matching types which are re-exported from the sibling
// `index.ts` file.

// istanbul ignore next: non-production
// eslint-disable-next-line no-unused-expressions
graphql`
  fragment ReportWizard_DetailedReportReasonFragment on DetailedReportReason {
    id
    title
    deadEndType
  }
`;

// istanbul ignore next: non-production
// eslint-disable-next-line no-unused-expressions
graphql`
  fragment ReportWizard_ReportReasonFragment on ReportReason {
    id
    text
    isApplicableToCountryRegulations
    description
    detailedReasons {
      id
      title
      deadEndType
    }
  }
`;

// istanbul ignore next: non-production
// eslint-disable-next-line no-unused-expressions
graphql`
  fragment ReportWizard_ReportToSAndCountryReasonsFragment on ReportToSAndCountryReasons {
    id
    countryCode
    disclosureText
    toSAndCountryReasons {
      id
      text
      isApplicableToCountryRegulations
      description
      detailedReasons {
        id
        title
        deadEndType
      }
    }
  }
`;

// istanbul ignore next: non-production
// eslint-disable-next-line no-unused-expressions
graphql`
  fragment ReportWizard_ReportableContentReasonFragment on ReportableContentReason {
    id
    reportReason {
      id
    }
    visibility
  }
`;

// istanbul ignore next: non-production
// eslint-disable-next-line no-unused-expressions
graphql`
  fragment ReportWizard_ReportableContentFragment on ReportableContent {
    id
    type
    applicableReasons {
      id
      reportReason {
        id
      }
      visibility
    }
    deadEndType
  }
`;

// istanbul ignore next: non-production
// eslint-disable-next-line no-unused-expressions
graphql`
  fragment ReportWizard_ReportWizardFragment on ReportWizard {
    reasons {
      id
      countryCode
      disclosureText
      toSAndCountryReasons {
        id
        text
        isApplicableToCountryRegulations
        description
        detailedReasons {
          id
          title
          deadEndType
        }
      }
    }
    reportableContent {
      id
      type
      applicableReasons {
        id
        reportReason {
          id
        }
        visibility
      }
      deadEndType
    }
  }
`;
