import type { ReportContentType, ReportWizardFragment } from '..';

/**
 * ReportContentType that gracefully accepts new reportableContent types from
 * GQL before the package is updated
 */
export type GracefulContentType = ReportContentType | string;

/**
 * Type utility that allows for updating the type of reportableContent without
 * hard-coding other aspects of ReportWizardFragment
 */
type WithGracefulType<T extends ReportWizardFragment> = Omit<
  T,
  'reportableContent'
> & {
  reportableContent: ReadonlyArray<
    Omit<T['reportableContent'][0], 'type'> & {
      type: GracefulContentType;
    }
  >;
};

/**
 * ReportWizardFragment that gracefully accepts new reportableContent types from
 * GQL before the package is updated
 */
export type GracefulReportWizardFragment =
  WithGracefulType<ReportWizardFragment>;
