import type { ReportUserContentInput } from '../gql-types';
import { ReportWizardStep } from './steps';

// report wizard's context and form should be agnositc to 'sessionID'
export type ReportForm = Partial<Omit<ReportUserContentInput, 'sessionID'>>;
export type ReportFormCompleted = Omit<ReportUserContentInput, 'sessionID'>;

// each step should correlate to which form fields
// are modified in that step. ie. only 'content' field is modified
// in the content step.  There are similar fields like 'contentID'
// and 'contentMetadata' but they aren't modified in the wizard by the user.
export const reportStepsToFormFields: {
  [key in ReportWizardStep]: (keyof ReportForm)[];
} = {
  [ReportWizardStep.Content]: ['content'],
  [ReportWizardStep.DeadEnd]: [],
  [ReportWizardStep.DetailedReason]: ['detailedReason'],
  [ReportWizardStep.Description]: ['description'],
  [ReportWizardStep.NetzDG]: ['netzDGArgs'],
  [ReportWizardStep.Reason]: ['reason'],
};

export const reportStepsToHideForm = [
  ReportWizardStep.NetzDG,
  ReportWizardStep.DeadEnd,
];
