import type {
  DetailedReportReasonFragment,
  ReportReasonFragment,
  ReportWizardFragment,
  ReportableContentFragment,
  ReportableContentReasonFragment,
} from '../gql-types';

export const mockDetailedReasons: ReadonlyArray<DetailedReportReasonFragment> =
  [
    {
      deadEndType: 'REPORTABLE',
      id: 'bot',
      title: 'Bot',
    },
    {
      deadEndType: 'REPORTABLE',
      id: 'scam',
      title: 'Scam',
    },
    {
      deadEndType: 'REPORTABLE',
      id: 'spam',
      title: 'Spam',
    },
  ];
export const mockDetailedReason = mockDetailedReasons[0];

export const mockAllReasons: ReportReasonFragment[] = [
  {
    description: '',
    detailedReasons: mockDetailedReasons,
    id: 'spam',
    isApplicableToCountryRegulations: false,
    text: 'Spam, Scams or Bots',
  },
  {
    description: '',
    detailedReasons: [],
    id: 'banevasion',
    isApplicableToCountryRegulations: false,
    text: 'Ban Evasion',
  },
  {
    description: '',
    detailedReasons: [],
    id: 'cheating',
    isApplicableToCountryRegulations: false,
    text: 'Cheating',
  },
  {
    description: '',
    detailedReasons: [
      {
        deadEndType: 'LINK_DMCA_GUIDELINES',
        id: 'ipviolation',
        title: 'IP Violation',
      },
    ],
    id: 'impersonation',
    isApplicableToCountryRegulations: false,
    text: 'Impersonation',
  },
  {
    description: '',
    detailedReasons: [],
    id: 'pranks',
    isApplicableToCountryRegulations: false,
    text: 'Malicious Pranks',
  },
];

export const mockTOSReason: ReportReasonFragment = mockAllReasons[1];
export const mockNetzDGReason: ReportReasonFragment = {
  ...mockAllReasons[0],
  isApplicableToCountryRegulations: true,
};
const mockMainReasons: ReadonlyArray<ReportReasonFragment> =
  mockAllReasons.slice(0, 2);
export const mockReasons = {
  allReasons: mockAllReasons,
  mainReasons: mockMainReasons,
};

const applicableReasons: ReadonlyArray<ReportableContentReasonFragment> = [
  {
    id: 'applicablereason-spam',
    reportReason: { id: 'spam' },
    visibility: 'MAIN',
  },
  {
    id: 'applicablereason-banevasion',
    reportReason: { id: 'banevasion' },
    visibility: 'MAIN',
  },
  {
    id: 'applicablereason-cheating',
    reportReason: { id: 'cheating' },
    visibility: 'SEARCH',
  },
];

export const mockContents: ReadonlyArray<ReportableContentFragment> = [
  {
    applicableReasons,
    deadEndType: 'REPORT_FROM_VOD',
    id: 'vod-report-id',
    type: 'VOD_REPORT',
  },
  {
    applicableReasons,
    deadEndType: 'REPORT_FROM_CLIP',
    id: 'clip-report-id',
    type: 'CLIP_REPORT',
  },
  {
    applicableReasons,
    deadEndType: 'LINK_OFF_PLATFORM_GUIDELINES',
    id: 'off-platform-report-id',
    type: 'OFF_PLATFORM_REPORT',
  },
];

export const mockReportWizardData: ReportWizardFragment = {
  reasons: {
    countryCode: null,
    disclosureText: null,
    id: 'reasons-data-id',
    toSAndCountryReasons: mockAllReasons,
  },
  reportableContent: mockContents,
};

export const mockReportWizardNetzDGData: ReportWizardFragment = {
  reasons: {
    countryCode: null,
    disclosureText: 'disclosureText',
    id: 'reasons-netzdg-data-id',
    toSAndCountryReasons: mockAllReasons.map((r) => ({
      ...r,
      isApplicableToCountryRegulations: true,
    })),
  },
  reportableContent: mockContents,
};
