import type { FC } from 'react';
import { useContext } from 'react';
import { ConfirmationScreen, reportWizardContext } from '../../components';

type ConfirmationProps = {};

export const Confirmation: FC<ConfirmationProps> = () => {
  const { closeWizard, hideBlockPrompt, targetUserBlocked, toggleBlock } =
    useContext(reportWizardContext);

  return (
    <ConfirmationScreen
      hideBlockPrompt={hideBlockPrompt}
      isBlocked={targetUserBlocked}
      onClickClose={closeWizard}
      onToggleBlockUser={toggleBlock}
    />
  );
};

Confirmation.displayName = 'Confirmation';
