import { createMountWrapperFactory } from 'tachyon-test-utils';
import {
  ConfirmationScreen,
  mockReportWizardContext,
  reportWizardContext,
} from '../../components';
import { Confirmation } from '.';

describe(Confirmation, () => {
  const setup = createMountWrapperFactory(Confirmation, undefined, {
    wrappingContexts: () => [
      mockReportWizardContext({
        closeWizard: jest.fn(),
        toggleBlock: jest.fn(),
      }),
    ],
  });

  it('calls closeWizard when onClickClose is invoked', () => {
    const { contexts, wrapper } = setup();
    wrapper.find(ConfirmationScreen).props().onClickClose?.();
    expect(contexts.get(reportWizardContext).closeWizard).toHaveBeenCalledTimes(
      1,
    );
  });

  it('calls toggleBlock when onToggleBlockUser is invoked', () => {
    const { contexts, wrapper } = setup();
    wrapper.find(ConfirmationScreen).props().onToggleBlockUser?.(true);
    expect(contexts.get(reportWizardContext).toggleBlock).toHaveBeenCalledWith(
      true,
    );
  });

  it("sets hideBlockPrompt according to context's hideBlockPrompt", () => {
    const { wrapper: wrapperAlreadyBlocked } = setup(undefined, {
      wrappingContexts: [
        mockReportWizardContext({
          hideBlockPrompt: true,
        }),
      ],
    });
    const { wrapper: wrapperNotYetBlocked } = setup(undefined, {
      wrappingContexts: [
        mockReportWizardContext({
          hideBlockPrompt: false,
        }),
      ],
    });

    expect(
      wrapperAlreadyBlocked.find(ConfirmationScreen).props().hideBlockPrompt,
    ).toBe(true);
    expect(
      wrapperNotYetBlocked.find(ConfirmationScreen).props().hideBlockPrompt,
    ).toBe(false);
  });

  it("sets isBlocked according to context's targetUserBlocked", () => {
    const { wrapper } = setup(undefined, {
      wrappingContexts: [
        mockReportWizardContext({
          targetUserBlocked: true,
        }),
      ],
    });

    expect(wrapper.find(ConfirmationScreen).props().isBlocked).toBe(true);
  });
});
