import type { FC } from 'react';
import { useContext } from 'react';
import { useIntl } from 'tachyon-intl';
import { Layout, Title, TitleSize } from 'twitch-core-ui';
import { ContentSelect, reportWizardContext } from '../../components';

type ContentProps = {};

export const Content: FC<ContentProps> = () => {
  const { contents, next } = useContext(reportWizardContext);
  const { formatMessage } = useIntl();

  return (
    <Layout fullWidth>
      <Layout margin={{ bottom: 1 }}>
        <Title size={TitleSize.ExtraSmall}>
          {formatMessage('Where is the problem?', 'ContentLabel')}
        </Title>
      </Layout>
      <ContentSelect
        contents={contents}
        onSelect={(content) => {
          next({ content });
        }}
      />
    </Layout>
  );
};

Content.displayName = 'Content';
