import { createMountWrapperFactory } from 'tachyon-test-utils';
import { Button } from 'twitch-core-ui';
import { mockReportWizardContext, reportWizardContext } from '../../components';
import { mockContents } from '../../models';
import { Content } from '.';

describe(Content, () => {
  const setup = createMountWrapperFactory(Content, undefined, {
    wrappingContexts: () => [
      mockReportWizardContext({
        contents: mockContents,
        next: jest.fn(),
        setFormValue: jest.fn(),
      }),
    ],
  });

  it('sets form value and calls next to wizard context when a content is selected', () => {
    const { contexts, wrapper } = setup();

    wrapper.find(Button).first().simulate('click');
    expect(contexts.get(reportWizardContext).next).toHaveBeenCalledWith({
      content: mockContents[0].type,
    });
  });
});
