import type { FC } from 'react';
import { useContext } from 'react';
import { useEffectOnce } from 'tachyon-utils-react';
import { DeadEndScreen, reportWizardContext } from '../../components';

type DeadEndProps = {};

export const DeadEnd: FC<DeadEndProps> = () => {
  const { deadEndType, setHideBackButton } = useContext(reportWizardContext);

  useEffectOnce(() => {
    setHideBackButton(true);
    return () => setHideBackButton(false);
  });

  return <DeadEndScreen deadEndType={deadEndType} />;
};

DeadEnd.displayName = 'DeadEnd';
