import { createMountWrapperFactory } from 'tachyon-test-utils';
import {
  DeadEndScreen,
  mockReportWizardContext,
  reportWizardContext,
} from '../../components';
import { DeadEnd } from '.';

describe(DeadEnd, () => {
  const setup = createMountWrapperFactory(DeadEnd, undefined, {
    wrappingContexts: () => [
      mockReportWizardContext({
        deadEndType: 'REPORTABLE',
        setHideBackButton: jest.fn(),
      }),
    ],
  });

  it('passes the deadend type to its child component', () => {
    const { contexts, wrapper } = setup();
    const expected = contexts.get(reportWizardContext).deadEndType;
    expect(wrapper.find(DeadEndScreen).props().deadEndType).toEqual(expected);
  });

  it('calls context to hide back button', async () => {
    const { contexts } = setup();
    expect(
      contexts.get(reportWizardContext).setHideBackButton,
    ).toHaveBeenCalledWith(true);
  });
});
