import { act } from 'react-dom/test-utils';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import {
  DescriptionForm,
  mockReportWizardContext,
  reportWizardContext,
} from '../../components';
import { Description } from '.';

describe(Description, () => {
  const setup = createMountWrapperFactory(Description, undefined, {
    wrappingContexts: () => [
      mockReportWizardContext({
        setFormValue: jest.fn(),
      }),
    ],
  });

  it('sets form value', () => {
    const { contexts, wrapper } = setup();
    const reportDescription = 'report description';
    act(() => {
      wrapper.find(DescriptionForm).props().onChange(reportDescription);
    });
    wrapper.update();

    expect(contexts.get(reportWizardContext).setFormValue).toHaveBeenCalledWith(
      { description: 'report description' },
    );
  });
});
