import type { FC } from 'react';
import { useContext } from 'react';
import { useIntl } from 'tachyon-intl';
import { Layout, Title, TitleSize } from 'twitch-core-ui';
import { DetailedReasonSelect, reportWizardContext } from '../../components';

type DetailedReasonProps = {};

export const DetailedReason: FC<DetailedReasonProps> = () => {
  const { detailedReasons, next } = useContext(reportWizardContext);
  const { formatMessage } = useIntl();

  return (
    <Layout fullWidth>
      <Layout margin={{ bottom: 1 }}>
        <Title size={TitleSize.ExtraSmall}>
          {formatMessage('Can you give us more information?', 'ReasonLabel')}
        </Title>
      </Layout>
      <DetailedReasonSelect
        onSelect={(reason) => {
          next({ detailedReason: reason });
        }}
        reasons={detailedReasons}
      />
    </Layout>
  );
};

DetailedReason.displayName = 'DetailedReason';
