import { createMountWrapperFactory } from 'tachyon-test-utils';
import { Button } from 'twitch-core-ui';
import { mockReportWizardContext, reportWizardContext } from '../../components';
import { mockDetailedReasons } from '../../models';
import { DetailedReason } from '.';

describe(DetailedReason, () => {
  const setup = createMountWrapperFactory(DetailedReason, undefined, {
    wrappingContexts: () => [
      mockReportWizardContext({
        detailedReasons: mockDetailedReasons,
        next: jest.fn(),
        setFormValue: jest.fn(),
      }),
    ],
  });

  it('sets form value and calls next to wizard context when a content is selected', () => {
    const { contexts, wrapper } = setup();

    wrapper.find(Button).first().simulate('click');
    expect(contexts.get(reportWizardContext).next).toHaveBeenCalledWith({
      detailedReason: mockDetailedReasons[0].id,
    });
  });
});
