import type { FC } from 'react';
import { useCallback, useContext } from 'react';
import { NetzDGForm, reportWizardContext } from '../../components';
import type { ReportContentNetzDGInput } from '../../gql-types';

type NetzDGProps = {};

export const NetzDG: FC<NetzDGProps> = () => {
  const { setFormValue } = useContext(reportWizardContext);
  const handleOnValidationChange = useCallback(
    (form?: ReportContentNetzDGInput) => {
      setFormValue({ netzDGArgs: form });
    },
    [setFormValue],
  );

  return <NetzDGForm onFormValidationChange={handleOnValidationChange} />;
};

NetzDG.displayName = 'NetzDG';
